export * from "./Barcode.js";
export * from "./Beacon.js";
export * from "./Location.js";
export * from "./Field.js";
export * from "./NFC.js";
export * from "./Semantics.js";
export * from "./PassFields.js";
export * from "./Personalize.js";
export * from "./Certificates.js";
import Joi from "joi";
import type { Buffer } from "node:buffer";
import { Barcode } from "./Barcode.js";
import { Location } from "./Location.js";
import { Beacon } from "./Beacon.js";
import { NFC } from "./NFC.js";
import { PassFields, TransitType } from "./PassFields.js";
import { Semantics } from "./Semantics.js";
import { CertificatesSchema } from "./Certificates.js";
export type PreferredStyleSchemes = ("posterEventTicket" | "eventTicket")[];
export declare const PreferredStyleSchemes: Joi.ArraySchema;
/**
 * A single interval can span at most 24 hours
 */
export interface RelevancyInterval {
    startDate: string | Date;
    endDate: string | Date;
}
export interface RelevancyEntry {
    relevantDate: string | Date;
}
/**
 * @iOSVersion 18
 *
 * Using a RelevancyInterval, will trigger a live activity on
 * new event ticket passes.
 *
 * Using a RelevancyEntry, will match the behavior of the
 * currently deprecated property `relevantDate`.
 */
export type RelevantDate = RelevancyInterval | RelevancyEntry;
export declare const RelevantDate: Joi.AlternativesSchema;
export interface FileBuffers {
    [key: string]: Buffer;
}
export interface PassProps {
    formatVersion?: 1;
    serialNumber?: string;
    description?: string;
    organizationName?: string;
    passTypeIdentifier?: string;
    teamIdentifier?: string;
    appLaunchURL?: string;
    voided?: boolean;
    userInfo?: {
        [key: string]: any;
    };
    sharingProhibited?: boolean;
    groupingIdentifier?: string;
    suppressStripShine?: boolean;
    logoText?: string;
    maxDistance?: number;
    semantics?: Semantics;
    webServiceURL?: string;
    associatedStoreIdentifiers?: Array<number>;
    authenticationToken?: string;
    backgroundColor?: string;
    foregroundColor?: string;
    labelColor?: string;
    /**
     * Undocumented feature:
     * Color of primary fields value when
     * rendered on top of a strip.
     */
    stripColor?: string;
    nfc?: NFC;
    beacons?: Beacon[];
    barcodes?: Barcode[];
    /**
     * @deprecated starting from iOS 18
     * Use `relevantDates`
     */
    relevantDate?: string;
    relevantDates?: RelevantDate[];
    expirationDate?: string;
    locations?: Location[];
    boardingPass?: PassFields & {
        transitType: TransitType;
    };
    eventTicket?: PassFields;
    coupon?: PassFields;
    generic?: PassFields;
    storeCard?: PassFields;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    preferredStyleSchemes?: PreferredStyleSchemes;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain event guide" must be used.
     */
    bagPolicyURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    orderFoodURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    parkingInformationURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    directionsInformationURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * @description
     *
     * URL to a resource to buy or access
     * the parking spot.
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    purchaseParkingURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * @description
     *
     * URL to a resource to buy the
     * merchandise.
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    merchandiseURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * @description
     *
     * URL to a resource about public or
     * private transportation to reach the
     * venue.
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    transitInformationURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * @description
     *
     * URL to a resource about accessibility
     * in the events venue.
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    accessibilityURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * @description
     *
     * An URL to link experiences to the
     * pass (upgrades and more).
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    addOnURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    contactVenueEmail?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    contactVenuePhoneNumber?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Event Guide
     *
     * To show buttons in the event guide,
     * at least two among those marked with
     * "@passDomain Event Guide" must be used.
     */
    contactVenueWebsite?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Menu dropdown
     *
     * @description
     *
     * Will add a button among options near "share"
     */
    transferURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain Menu dropdown
     *
     * @description
     *
     * Will add a button among options near "share"
     */
    sellURL?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     *
     * @description
     *
     * Will remove an automatic shadow in the new
     * event ticket layouts.
     */
    suppressHeaderDarkening?: boolean;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     *
     * @description
     *
     * By default, the chin is colored with a
     * blur. Through this option, it is possible
     * to specify a different and specific color
     * for it.
     */
    footerBackgroundColor?: string;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     *
     * @description
     *
     * Enables the automatic calculation of the
     * `foregroundColor` and `labelColor` based
     * on the background image in the new event
     * ticket passes.
     *
     * If enabled, `foregroundColor` and `labelColor`
     * are ignored.
     */
    useAutomaticColor?: boolean;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     *
     * @description
     *
     * Applications AppStore Identifiers
     * related to the event ticket.
     *
     * It is not mandatory for the app to
     * be related to the pass issuer.
     *
     * Such applications won't be able to read
     * the passes users has (probably differently
     * by `associatedStoreIdentifiers`).
     */
    auxiliaryStoreIdentifiers?: number[];
}
/**
 * These are the properties passkit-generator will
 * handle through its methods
 */
type PassMethodsProps = "nfc" | "beacons" | "barcodes" | "relevantDate" | "relevantDates" | "expirationDate" | "locations" | "preferredStyleSchemes";
export type PassTypesProps = "boardingPass" | "eventTicket" | "coupon" | "generic" | "storeCard";
export type OverridablePassProps = Omit<PassProps, PassMethodsProps | PassTypesProps>;
export type PassPropsFromMethods = {
    [K in PassMethodsProps]: PassProps[K];
};
export type PassKindsProps = {
    [K in PassTypesProps]: PassProps[K];
};
export type PassColors = Pick<OverridablePassProps, "backgroundColor" | "foregroundColor" | "labelColor" | "stripColor">;
export declare const PassPropsFromMethods: Joi.ObjectSchema<PassPropsFromMethods>;
export declare const PassKindsProps: Joi.ObjectSchema<PassKindsProps>;
export declare const PassType: Joi.StringSchema;
export declare const OverridablePassProps: Joi.ObjectSchema<OverridablePassProps>;
export declare const PassProps: Joi.ObjectSchema<OverridablePassProps & PassKindsProps & PassPropsFromMethods>;
export interface Template {
    model: string;
    certificates?: CertificatesSchema;
}
export declare const Template: Joi.ObjectSchema<Template>;
/**
 * Performs validation of a schema on an object.
 * If it fails, will throw an error.
 *
 * @param schema
 * @param data
 */
export declare function assertValidity<T>(schema: Joi.Schema<T>, data: T, customErrorMessage?: string): void;
/**
 * Performs validation and throws the error if there's one.
 * Otherwise returns a (possibly patched) version of the specified
 * options (it depends on the schema)
 *
 * @param schema
 * @param options
 * @returns
 */
export declare function validate<T extends Object>(schema: Joi.Schema<T>, options: T): T;
export declare function filterValid<T extends Object>(schema: Joi.ObjectSchema<T>, source: T[]): T[];
