import Joi from "joi";
import { Field, FieldWithRow } from "./Field.js";
export type TransitType = "PKTransitTypeAir" | "PKTransitTypeBoat" | "PKTransitTypeBus" | "PKTransitTypeGeneric" | "PKTransitTypeTrain";
export declare const TransitType: Joi.StringSchema;
export interface PassFields {
    auxiliaryFields: FieldWithRow[];
    backFields: Field[];
    headerFields: Field[];
    primaryFields: Field[];
    secondaryFields: Field[];
    transitType?: TransitType;
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain dashboard
     *
     * @see \<undiclosed>
     */
    additionalInfoFields?: Field[];
}
export declare const PassFields: Joi.ObjectSchema<PassFields>;
