import * as Messages from "./messages.js";
/**
 * Converts a date to W3C / UTC string
 * @param date
 * @returns
 */
export function processDate(date) {
    if (!(date instanceof Date) || Number.isNaN(Number(date))) {
        throw "Invalid date";
    }
    /**
     * @see https://www.w3.org/TR/NOTE-datetime
     */
    return date.toISOString();
}
/**
 * Removes hidden files from a list (those starting with dot)
 *
 * @params from - list of file names
 * @return
 */
export function removeHidden(from) {
    return from.filter((e) => e.charAt(0) !== ".");
}
/**
 * Clones recursively an object and all of its properties
 *
 * @param object
 * @returns
 */
export function cloneRecursive(object) {
    const objectCopy = {};
    const objectEntries = Object.entries(object);
    for (let i = 0; i < objectEntries.length; i++) {
        const [key, value] = objectEntries[i];
        if (value && typeof value === "object") {
            if (Array.isArray(value)) {
                objectCopy[key] = value.slice();
                for (let j = 0; j < value.length; j++) {
                    objectCopy[key][j] = cloneRecursive(value[j]);
                }
            }
            else {
                objectCopy[key] = cloneRecursive(value);
            }
        }
        else {
            objectCopy[key] = value;
        }
    }
    return objectCopy;
}
export function assertUnfrozen(instance) {
    if (instance.isFrozen) {
        throw new Error(Messages.BUNDLE.CLOSED);
    }
}
//# sourceMappingURL=data:application/json;base64,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