import Joi from "joi";
import { RGB_HEX_COLOR_REGEX } from "./regexps.js";
export const CurrencyAmount = Joi.object().keys({
    currencyCode: Joi.string(),
    amount: Joi.string(),
});
export const EventDateInfo = Joi.object().keys({
    date: Joi.string().isoDate().required(),
    ignoreTimeComponents: Joi.boolean(),
    timeZone: Joi.string(),
});
export const Location = Joi.object().keys({
    latitude: Joi.number().required(),
    longitude: Joi.number().required(),
});
export const PersonNameComponents = Joi.object().keys({
    givenName: Joi.string(),
    familyName: Joi.string(),
    middleName: Joi.string(),
    namePrefix: Joi.string(),
    nameSuffix: Joi.string(),
    nickname: Joi.string(),
    phoneticRepresentation: Joi.string(),
});
export const Seat = Joi.object().keys({
    seatSection: Joi.string(),
    seatRow: Joi.string(),
    seatNumber: Joi.string(),
    seatIdentifier: Joi.string(),
    seatType: Joi.string(),
    seatDescription: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatAisle: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatLevel: Joi.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatSectionColor: Joi.string().regex(RGB_HEX_COLOR_REGEX),
});
export const WifiNetwork = Joi.object().keys({
    password: Joi.string().required(),
    ssid: Joi.string().required(),
});
//# sourceMappingURL=data:application/json;base64,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