import Joi from "joi";
import { Field, FieldWithRow } from "./Field.js";
export const TransitType = Joi.string().regex(/(PKTransitTypeAir|PKTransitTypeBoat|PKTransitTypeBus|PKTransitTypeGeneric|PKTransitTypeTrain)/);
export const PassFields = Joi.object().keys({
    auxiliaryFields: Joi.array().items(FieldWithRow),
    backFields: Joi.array().items(Field),
    headerFields: Joi.array().items(Field),
    primaryFields: Joi.array().items(Field),
    secondaryFields: Joi.array().items(Field),
    transitType: TransitType,
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     * @passDomain dashboard
     *
     * @see \<undiclosed>
     */
    additionalInfoFields: Joi.array().items(Field),
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUGFzc0ZpZWxkcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zY2hlbWFzL1Bhc3NGaWVsZHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxHQUFHLE1BQU0sS0FBSyxDQUFDO0FBQ3RCLE9BQU8sRUFBRSxLQUFLLEVBQUUsWUFBWSxFQUFFLE1BQU0sWUFBWSxDQUFDO0FBU2pELE1BQU0sQ0FBQyxNQUFNLFdBQVcsR0FBRyxHQUFHLENBQUMsTUFBTSxFQUFFLENBQUMsS0FBSyxDQUM1QywrRkFBK0YsQ0FDL0YsQ0FBQztBQW9CRixNQUFNLENBQUMsTUFBTSxVQUFVLEdBQUcsR0FBRyxDQUFDLE1BQU0sRUFBYyxDQUFDLElBQUksQ0FBQztJQUN2RCxlQUFlLEVBQUUsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUM7SUFDaEQsVUFBVSxFQUFFLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDO0lBQ3BDLFlBQVksRUFBRSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQztJQUN0QyxhQUFhLEVBQUUsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUM7SUFDdkMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDO0lBQ3pDLFdBQVcsRUFBRSxXQUFXO0lBRXhCOzs7Ozs7T0FNRztJQUNILG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDO0NBQzlDLENBQUMsQ0FBQyJ9