import Joi from "joi";
export const Barcode = Joi.object().keys({
    altText: Joi.string(),
    messageEncoding: Joi.string().default("iso-8859-1"),
    format: Joi.string()
        .required()
        .regex(/(PKBarcodeFormatQR|PKBarcodeFormatPDF417|PKBarcodeFormatAztec|PKBarcodeFormatCode128)/, "barcodeType"),
    message: Joi.string().required(),
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQmFyY29kZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zY2hlbWFzL0JhcmNvZGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxHQUFHLE1BQU0sS0FBSyxDQUFDO0FBbUJ0QixNQUFNLENBQUMsTUFBTSxPQUFPLEdBQUcsR0FBRyxDQUFDLE1BQU0sRUFBVyxDQUFDLElBQUksQ0FBQztJQUNqRCxPQUFPLEVBQUUsR0FBRyxDQUFDLE1BQU0sRUFBRTtJQUNyQixlQUFlLEVBQUUsR0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUM7SUFDbkQsTUFBTSxFQUFFLEdBQUcsQ0FBQyxNQUFNLEVBQUU7U0FDbEIsUUFBUSxFQUFFO1NBQ1YsS0FBSyxDQUNMLHVGQUF1RixFQUN2RixhQUFhLENBQ2I7SUFDRixPQUFPLEVBQUUsR0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDLFFBQVEsRUFBRTtDQUNoQyxDQUFDLENBQUMifQ==