"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processDate = processDate;
exports.removeHidden = removeHidden;
exports.cloneRecursive = cloneRecursive;
exports.assertUnfrozen = assertUnfrozen;
const tslib_1 = require("tslib");
const Messages = tslib_1.__importStar(require("./messages.js"));
/**
 * Converts a date to W3C / UTC string
 * @param date
 * @returns
 */
function processDate(date) {
    if (!(date instanceof Date) || Number.isNaN(Number(date))) {
        throw "Invalid date";
    }
    /**
     * @see https://www.w3.org/TR/NOTE-datetime
     */
    return date.toISOString();
}
/**
 * Removes hidden files from a list (those starting with dot)
 *
 * @params from - list of file names
 * @return
 */
function removeHidden(from) {
    return from.filter((e) => e.charAt(0) !== ".");
}
/**
 * Clones recursively an object and all of its properties
 *
 * @param object
 * @returns
 */
function cloneRecursive(object) {
    const objectCopy = {};
    const objectEntries = Object.entries(object);
    for (let i = 0; i < objectEntries.length; i++) {
        const [key, value] = objectEntries[i];
        if (value && typeof value === "object") {
            if (Array.isArray(value)) {
                objectCopy[key] = value.slice();
                for (let j = 0; j < value.length; j++) {
                    objectCopy[key][j] = cloneRecursive(value[j]);
                }
            }
            else {
                objectCopy[key] = cloneRecursive(value);
            }
        }
        else {
            objectCopy[key] = value;
        }
    }
    return objectCopy;
}
function assertUnfrozen(instance) {
    if (instance.isFrozen) {
        throw new Error(Messages.BUNDLE.CLOSED);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFTQSxrQ0FVQztBQVNELG9DQUVDO0FBU0Qsd0NBdUJDO0FBRUQsd0NBTUM7O0FBdEVELGdFQUEwQztBQUcxQzs7OztHQUlHO0FBRUgsU0FBZ0IsV0FBVyxDQUFDLElBQVU7SUFDckMsSUFBSSxDQUFDLENBQUMsSUFBSSxZQUFZLElBQUksQ0FBQyxJQUFJLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUMzRCxNQUFNLGNBQWMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7O09BRUc7SUFFSCxPQUFPLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztBQUMzQixDQUFDO0FBRUQ7Ozs7O0dBS0c7QUFFSCxTQUFnQixZQUFZLENBQUMsSUFBbUI7SUFDL0MsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO0FBQ2hELENBQUM7QUFFRDs7Ozs7R0FLRztBQUVILFNBQWdCLGNBQWMsQ0FBbUIsTUFBUztJQUN6RCxNQUFNLFVBQVUsR0FBRyxFQUEwQixDQUFDO0lBQzlDLE1BQU0sYUFBYSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUE0QixDQUFDO0lBRXhFLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxhQUFhLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUM7UUFDL0MsTUFBTSxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFFdEMsSUFBSSxLQUFLLElBQUksT0FBTyxLQUFLLEtBQUssUUFBUSxFQUFFLENBQUM7WUFDeEMsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7Z0JBQzFCLFVBQVUsQ0FBQyxHQUFHLENBQUMsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBRWhDLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUM7b0JBQ3ZDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxjQUFjLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7Z0JBQy9DLENBQUM7WUFDRixDQUFDO2lCQUFNLENBQUM7Z0JBQ1AsVUFBVSxDQUFDLEdBQUcsQ0FBQyxHQUFHLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUN6QyxDQUFDO1FBQ0YsQ0FBQzthQUFNLENBQUM7WUFDUCxVQUFVLENBQUMsR0FBRyxDQUFDLEdBQUcsS0FBSyxDQUFDO1FBQ3pCLENBQUM7SUFDRixDQUFDO0lBRUQsT0FBTyxVQUFVLENBQUM7QUFDbkIsQ0FBQztBQUVELFNBQWdCLGNBQWMsQ0FDN0IsUUFBcUM7SUFFckMsSUFBSSxRQUFRLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDdkIsTUFBTSxJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7QUFDRixDQUFDIn0=