"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Semantics = void 0;
const tslib_1 = require("tslib");
const joi_1 = tslib_1.__importDefault(require("joi"));
const SemanticTagType = tslib_1.__importStar(require("./SemanticTagType.js"));
exports.Semantics = joi_1.default.object().keys({
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    admissionLevel: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    admissionLevelAbbreviation: joi_1.default.string(),
    airlineCode: joi_1.default.string(),
    artistIDs: joi_1.default.array().items(joi_1.default.string()),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    albumIDs: joi_1.default.array().items(joi_1.default.string()),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    airplay: joi_1.default.array().items({
        airplayDeviceGroupToken: joi_1.default.string(),
    }),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    attendeeName: joi_1.default.string(),
    awayTeamAbbreviation: joi_1.default.string(),
    awayTeamLocation: joi_1.default.string(),
    awayTeamName: joi_1.default.string(),
    additionalTicketAttributes: joi_1.default.string(),
    balance: SemanticTagType.CurrencyAmount,
    boardingGroup: joi_1.default.string(),
    boardingSequenceNumber: joi_1.default.string(),
    carNumber: joi_1.default.string(),
    confirmationNumber: joi_1.default.string(),
    currentArrivalDate: joi_1.default.string(),
    currentBoardingDate: joi_1.default.string(),
    currentDepartureDate: joi_1.default.string(),
    departureAirportCode: joi_1.default.string(),
    departureAirportName: joi_1.default.string(),
    departureGate: joi_1.default.string(),
    departureLocation: SemanticTagType.Location,
    departureLocationDescription: joi_1.default.string(),
    departurePlatform: joi_1.default.string(),
    departureStationName: joi_1.default.string(),
    departureTerminal: joi_1.default.string(),
    destinationAirportCode: joi_1.default.string(),
    destinationAirportName: joi_1.default.string(),
    destinationGate: joi_1.default.string(),
    destinationLocation: SemanticTagType.Location,
    destinationLocationDescription: joi_1.default.string(),
    destinationPlatform: joi_1.default.string(),
    destinationStationName: joi_1.default.string(),
    destinationTerminal: joi_1.default.string(),
    duration: joi_1.default.number(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    entranceDescription: joi_1.default.string(),
    eventEndDate: joi_1.default.string(),
    eventName: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     *
     * Shows a message in the live activity
     * when the activity starts.
     */
    eventLiveMessage: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout).
     *
     * Can be used as an alternative way to
     * show show start date, with more control
     * on time and timeZone details and as
     * a way to show the event guide, both
     * instead of `eventStartDate`.
     */
    eventStartDateInfo: SemanticTagType.EventDateInfo,
    eventStartDate: joi_1.default.string(),
    eventType: joi_1.default.string().regex(/(PKEventTypeGeneric|PKEventTypeLivePerformance|PKEventTypeMovie|PKEventTypeSports|PKEventTypeConference|PKEventTypeConvention|PKEventTypeWorkshop|PKEventTypeSocialGathering)/),
    flightCode: joi_1.default.string(),
    flightNumber: joi_1.default.number(),
    genre: joi_1.default.string(),
    homeTeamAbbreviation: joi_1.default.string(),
    homeTeamLocation: joi_1.default.string(),
    homeTeamName: joi_1.default.string(),
    leagueAbbreviation: joi_1.default.string(),
    leagueName: joi_1.default.string(),
    membershipProgramName: joi_1.default.string(),
    membershipProgramNumber: joi_1.default.string(),
    originalArrivalDate: joi_1.default.string(),
    originalBoardingDate: joi_1.default.string(),
    originalDepartureDate: joi_1.default.string(),
    passengerName: SemanticTagType.PersonNameComponents,
    performerNames: joi_1.default.array().items(joi_1.default.string()),
    priorityStatus: joi_1.default.string(),
    playlistIDs: joi_1.default.array().items(joi_1.default.string()),
    seats: joi_1.default.array().items(SemanticTagType.Seat),
    securityScreening: joi_1.default.string(),
    silenceRequested: joi_1.default.boolean(),
    sportName: joi_1.default.string(),
    tailgatingAllowed: joi_1.default.boolean(),
    totalPrice: SemanticTagType.CurrencyAmount,
    transitProvider: joi_1.default.string(),
    transitStatus: joi_1.default.string(),
    transitStatusReason: joi_1.default.string(),
    vehicleName: joi_1.default.string(),
    vehicleNumber: joi_1.default.string(),
    vehicleType: joi_1.default.string(),
    venueEntrance: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueGatesOpenDate: joi_1.default.string(),
    venueLocation: SemanticTagType.Location,
    venueName: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueParkingLotsOpenDate: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueBoxOfficeOpenDate: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueDoorsOpenDate: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueFanZoneOpenDate: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueOpenDate: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueCloseDate: joi_1.default.string(),
    venuePhoneNumber: joi_1.default.string(),
    venueRoom: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueRegionName: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntranceGate: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntranceDoor: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    venueEntrancePortal: joi_1.default.string(),
    wifiAccess: joi_1.default.array().items(SemanticTagType.WifiNetwork),
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU2VtYW50aWNzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3NjaGVtYXMvU2VtYW50aWNzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxzREFBc0I7QUFDdEIsOEVBQXdEO0FBaVIzQyxRQUFBLFNBQVMsR0FBRyxhQUFHLENBQUMsTUFBTSxFQUFhLENBQUMsSUFBSSxDQUFDO0lBQ3JEOzs7T0FHRztJQUNILGNBQWMsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRTVCOzs7T0FHRztJQUNILDBCQUEwQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFeEMsV0FBVyxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDekIsU0FBUyxFQUFFLGFBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsYUFBRyxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBRTFDOzs7T0FHRztJQUNILFFBQVEsRUFBRSxhQUFHLENBQUMsS0FBSyxFQUFFLENBQUMsS0FBSyxDQUFDLGFBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUV6Qzs7O09BR0c7SUFDSCxPQUFPLEVBQUUsYUFBRyxDQUFDLEtBQUssRUFBRSxDQUFDLEtBQUssQ0FBQztRQUMxQix1QkFBdUIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0tBQ3JDLENBQUM7SUFFRjs7O09BR0c7SUFDSCxZQUFZLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUUxQixvQkFBb0IsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQ2xDLGdCQUFnQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDOUIsWUFBWSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFMUIsMEJBQTBCLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUV4QyxPQUFPLEVBQUUsZUFBZSxDQUFDLGNBQWM7SUFDdkMsYUFBYSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDM0Isc0JBQXNCLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUVwQyxTQUFTLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUN2QixrQkFBa0IsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQ2hDLGtCQUFrQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDaEMsbUJBQW1CLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUNqQyxvQkFBb0IsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRWxDLG9CQUFvQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDbEMsb0JBQW9CLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUNsQyxhQUFhLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUMzQixpQkFBaUIsRUFBRSxlQUFlLENBQUMsUUFBUTtJQUMzQyw0QkFBNEIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQzFDLGlCQUFpQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDL0Isb0JBQW9CLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUNsQyxpQkFBaUIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQy9CLHNCQUFzQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDcEMsc0JBQXNCLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUNwQyxlQUFlLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUM3QixtQkFBbUIsRUFBRSxlQUFlLENBQUMsUUFBUTtJQUM3Qyw4QkFBOEIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQzVDLG1CQUFtQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDakMsc0JBQXNCLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUNwQyxtQkFBbUIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQ2pDLFFBQVEsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRXRCOzs7T0FHRztJQUNILG1CQUFtQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFakMsWUFBWSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDMUIsU0FBUyxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFdkI7Ozs7OztPQU1HO0lBQ0gsZ0JBQWdCLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUU5Qjs7Ozs7Ozs7O09BU0c7SUFDSCxrQkFBa0IsRUFBRSxlQUFlLENBQUMsYUFBYTtJQUVqRCxjQUFjLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUM1QixTQUFTLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRSxDQUFDLEtBQUssQ0FDNUIsK0tBQStLLENBQy9LO0lBRUQsVUFBVSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDeEIsWUFBWSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFMUIsS0FBSyxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFbkIsb0JBQW9CLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUNsQyxnQkFBZ0IsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQzlCLFlBQVksRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQzFCLGtCQUFrQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDaEMsVUFBVSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFeEIscUJBQXFCLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUNuQyx1QkFBdUIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRXJDLG1CQUFtQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDakMsb0JBQW9CLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUNsQyxxQkFBcUIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRW5DLGFBQWEsRUFBRSxlQUFlLENBQUMsb0JBQW9CO0lBQ25ELGNBQWMsRUFBRSxhQUFHLENBQUMsS0FBSyxFQUFFLENBQUMsS0FBSyxDQUFDLGFBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUMvQyxjQUFjLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUU1QixXQUFXLEVBQUUsYUFBRyxDQUFDLEtBQUssRUFBRSxDQUFDLEtBQUssQ0FBQyxhQUFHLENBQUMsTUFBTSxFQUFFLENBQUM7SUFFNUMsS0FBSyxFQUFFLGFBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQztJQUM5QyxpQkFBaUIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQy9CLGdCQUFnQixFQUFFLGFBQUcsQ0FBQyxPQUFPLEVBQUU7SUFDL0IsU0FBUyxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFdkIsaUJBQWlCLEVBQUUsYUFBRyxDQUFDLE9BQU8sRUFBRTtJQUVoQyxVQUFVLEVBQUUsZUFBZSxDQUFDLGNBQWM7SUFDMUMsZUFBZSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDN0IsYUFBYSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDM0IsbUJBQW1CLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUVqQyxXQUFXLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUN6QixhQUFhLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUMzQixXQUFXLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUV6QixhQUFhLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUUzQjs7O09BR0c7SUFDSCxrQkFBa0IsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRWhDLGFBQWEsRUFBRSxlQUFlLENBQUMsUUFBUTtJQUN2QyxTQUFTLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUV2Qjs7O09BR0c7SUFDSCx3QkFBd0IsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRXRDOzs7T0FHRztJQUNILHNCQUFzQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFcEM7OztPQUdHO0lBQ0gsa0JBQWtCLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUVoQzs7O09BR0c7SUFDSCxvQkFBb0IsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRWxDOzs7T0FHRztJQUNILGFBQWEsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRTNCOzs7T0FHRztJQUNILGNBQWMsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRTVCLGdCQUFnQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFDOUIsU0FBUyxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFdkI7OztPQUdHO0lBQ0gsZUFBZSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFN0I7OztPQUdHO0lBQ0gsaUJBQWlCLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRTtJQUUvQjs7O09BR0c7SUFDSCxpQkFBaUIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0lBRS9COzs7T0FHRztJQUNILG1CQUFtQixFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUU7SUFFakMsVUFBVSxFQUFFLGFBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQztDQUMxRCxDQUFDLENBQUMifQ==