"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WifiNetwork = exports.Seat = exports.PersonNameComponents = exports.Location = exports.EventDateInfo = exports.CurrencyAmount = void 0;
const tslib_1 = require("tslib");
const joi_1 = tslib_1.__importDefault(require("joi"));
const regexps_js_1 = require("./regexps.js");
exports.CurrencyAmount = joi_1.default.object().keys({
    currencyCode: joi_1.default.string(),
    amount: joi_1.default.string(),
});
exports.EventDateInfo = joi_1.default.object().keys({
    date: joi_1.default.string().isoDate().required(),
    ignoreTimeComponents: joi_1.default.boolean(),
    timeZone: joi_1.default.string(),
});
exports.Location = joi_1.default.object().keys({
    latitude: joi_1.default.number().required(),
    longitude: joi_1.default.number().required(),
});
exports.PersonNameComponents = joi_1.default.object().keys({
    givenName: joi_1.default.string(),
    familyName: joi_1.default.string(),
    middleName: joi_1.default.string(),
    namePrefix: joi_1.default.string(),
    nameSuffix: joi_1.default.string(),
    nickname: joi_1.default.string(),
    phoneticRepresentation: joi_1.default.string(),
});
exports.Seat = joi_1.default.object().keys({
    seatSection: joi_1.default.string(),
    seatRow: joi_1.default.string(),
    seatNumber: joi_1.default.string(),
    seatIdentifier: joi_1.default.string(),
    seatType: joi_1.default.string(),
    seatDescription: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatAisle: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatLevel: joi_1.default.string(),
    /**
     * @iOSVersion 18
     * @passStyle eventTicket (new layout)
     */
    seatSectionColor: joi_1.default.string().regex(regexps_js_1.RGB_HEX_COLOR_REGEX),
});
exports.WifiNetwork = joi_1.default.object().keys({
    password: joi_1.default.string().required(),
    ssid: joi_1.default.string().required(),
});
//# sourceMappingURL=data:application/json;base64,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