"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificatesSchema = void 0;
const tslib_1 = require("tslib");
const node_buffer_1 = require("node:buffer");
const joi_1 = tslib_1.__importDefault(require("joi"));
/**
 * Joi.binary is not available in browser-like environments (like Cloudflare workers)
 * so we fallback to manual checking. Buffer must be polyfilled.
 */
const binary = joi_1.default.binary
    ? joi_1.default.binary()
    : joi_1.default.custom((obj) => node_buffer_1.Buffer.isBuffer(obj));
exports.CertificatesSchema = joi_1.default.object()
    .keys({
    wwdr: joi_1.default.alternatives(binary, joi_1.default.string()).required(),
    signerCert: joi_1.default.alternatives(binary, joi_1.default.string()).required(),
    signerKey: joi_1.default.alternatives(binary, joi_1.default.string()).required(),
    signerKeyPassphrase: joi_1.default.string(),
})
    .required();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ2VydGlmaWNhdGVzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3NjaGVtYXMvQ2VydGlmaWNhdGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSw2Q0FBcUM7QUFDckMsc0RBQXNCO0FBU3RCOzs7R0FHRztBQUVILE1BQU0sTUFBTSxHQUFHLGFBQUcsQ0FBQyxNQUFNO0lBQ3hCLENBQUMsQ0FBQyxhQUFHLENBQUMsTUFBTSxFQUFFO0lBQ2QsQ0FBQyxDQUFDLGFBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLG9CQUFNLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7QUFFaEMsUUFBQSxrQkFBa0IsR0FBRyxhQUFHLENBQUMsTUFBTSxFQUFzQjtLQUNoRSxJQUFJLENBQUM7SUFDTCxJQUFJLEVBQUUsYUFBRyxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUUsYUFBRyxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUMsUUFBUSxFQUFFO0lBQ3ZELFVBQVUsRUFBRSxhQUFHLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQyxRQUFRLEVBQUU7SUFDN0QsU0FBUyxFQUFFLGFBQUcsQ0FBQyxZQUFZLENBQUMsTUFBTSxFQUFFLGFBQUcsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLFFBQVEsRUFBRTtJQUM1RCxtQkFBbUIsRUFBRSxhQUFHLENBQUMsTUFBTSxFQUFFO0NBQ2pDLENBQUM7S0FDRCxRQUFRLEVBQUUsQ0FBQyJ9